function limit = lim_T(i,Mi_init)

% Computes the limit of fixed point iterations on T for player i 
% starting from Mi_init.

%-------
% setup
%-------

% global

global beta plr Pr_data x_data n NA NY NW jstate

% local

ITRMAX = 100000;
ERRTOL = 1.0d-5;

%-------------
% computation
%-------------

Mi = Mi_init;

for itr=1:ITRMAX

    % update
    
    Mip = T(i,Mi);
    
    % evaluate distance b/w Mi and Mip and decide what to do
    
    if (PS_dist(i,Mi,Mip) < ERRTOL) 
        break
    else
        Mi = Mip;
    end 
    
    % warning if iterations exhausted
    
    if (itr==ITRMAX) 
        disp('**Warning: itr reached max in lim_T')
    end
    
end

limit = Mip;